package easik;

import easik.sketch.util.ini.IniSettings;
import easik.ui.ApplicationFrame;
import easik.ui.Help;

/** 
 * Easik is the starting point of the application. It creates an instance of the Application
 * frame and then allows for user interaction.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 20006-08-03 Kevin Green
 */

public class Easik {
	
	/**
	 * The instance of this sketch
	 */
	private static Easik _instance;
	
	/**
	 * The current Ini settings of this application, as defined in the .ini file
	 */
	private IniSettings _iniSettings;
	
	/**
	 * The current state manager
	 */
	private StateManager _stateManager; 
	/**
	 * The current frame
	 */
	private ApplicationFrame _theFrame;
	/**
	 * The help files
	 */
	private Help _bigHelp;
	
	/**
	 * Entry point of the Application. Creates an instance of the application.
	 * 
	 * @param args	Program parameters, currently ignored
	 */
	public static void main(String[] args) {
		Easik.getInstance();
	}		
	
	/**
	 * Creates an instance of the application frame and then sets it to be visible.
	 * <p>
	 * Creating an instance of this class will start running an instance of the application. 
	 */
	private Easik() {
		Easik._instance = this;
		_iniSettings = new IniSettings();
		_theFrame= new ApplicationFrame();
		_stateManager = new StateManager(this);
		_bigHelp = new Help();
		_theFrame.setVisible(true);
	}
	
	/**
	 * Singleton method to get the one instance
	 * 
	 * @return The one instance.
	 */
	public static Easik getInstance() {
		if (_instance == null) {			
			new Easik();
		} 		
		return _instance;		
	}	
	
	/**
	 * Gets the help pane associated with this instance.
	 * 
	 * @return The Easik help pane
	 */
	public Help getHelp() {
		return _bigHelp;
	}
	
	/**
	 * Returns the current application frame
	 * 
	 * @return The frame
	 */
	public ApplicationFrame getFrame() {
		return _theFrame;
	}

	/**
	 * Returns the current application frame
	 * 
	 * @return The frame
	 */
	public StateManager getStateManager() {
		return _stateManager;
	}
	
	/**
	 * Returns the ini settings
	 * 
	 * @return The ini settings
	 * @since 2006-07-12 Kevin Green
	 */
	public IniSettings getIni(){
		return _iniSettings;
	}
}
